%Earth_to_Moon_transit
% LAST UPDATED by Andy French Nov 2023

Me = 5.97e24;  %Earth mass in kg
Mm = 7.3e22;   %Moon mass in kg
G = 6.67e-11;   %Universal GRavitational constant in N m^2 kg^-2
Re = 6370e3;    %Earth radius /m
Rm = 1737.4e3;  %Moon radius /m
r_em = Re + Rm + 363104e3;  %Earth to Moon separation /m at perigee;
r_em = Re + Rm + 405696e3;  %Earth to Moon separation /m at apogee;

%Calculate gravitational potential from Earth surface to lunar surface
r = linspace(Re, r_em - Rm, 1000 );
phi = -G * ( Me./r + Mm./( r_em - r) );

%Calculate maximum phi
rmax = r_em/( 1 + sqrt(Mm/Me) );
phi_max = -G * ( Me/rmax + Mm/( r_em - rmax) )

%Plot phi vs r (in Earth radii)
plot( r/Re, phi ); hold on; plot( rmax/Re, phi_max,'r*' );
xlabel(' r / earth radius'); ylabel('Gravitational potential /Jkg^{-1}');
title('Gravitational potential between Earth and Moon'); grid on;
print(gcf,'earth-moon-transit.png','-dpng','-r300');
close(gcf);

%End of code